<?php

global $wp_query;

?><!DOCTYPE html>
<html lang="en">
<head>
	<link href='https://fonts.googleapis.com/css?family=Open+Sans:700,400,400italic' rel='stylesheet' type='text/css'>

	<meta charset="utf-8">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0"/>

	<title><?php echo __( 'Kanban for WordPress', 'kanban' ); ?></title>

	<!--[if lt IE 9]>
		<script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
		<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
	<![endif]-->

	<?php Kanban_Template::add_style($wp_query->query_vars['kanban']->slug); ?>
</head>
<body>

<div class="container">


<div class="row" style="margin-top: 60px;">



	<form action="" method="post" class="col-sm-4 col-sm-offset-4">
		<img src="<?php echo 'data:image/png;base64,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' ?>" class="img-responsive" style="margin: 0 auto 30px; max-width: 150px;">



		<?php Kanban_Flash::flash(); ?>



<!--		<div class="panel panel-default">-->
			<div class="panel-heading">
<?php if ( ! is_user_logged_in() ) : ?>
				<h2><?php echo __( 'Please Login', 'kanban' ); ?></h2>
				<div class="form-group">
					<label for="email" class="sr-only">
						<?php echo __( 'Email or username', 'kanban' ); ?>
					</label>
					<input type="text" name="email" id="email" class="form-control input-lg" placeholder="<?php echo __('Email or username', 'kanban'); ?>" required autofocus>
				</div><!-- form group -->
				<div class="form-group">
					<label for="password" class="sr-only">
						<?php echo __( 'Password', 'kanban' ); ?>
					</label>
					<input type="password" name="password" id="password" class="form-control input-lg" placeholder="<?php echo __('Password', 'kanban'); ?>" required>
				</div><!-- form group -->
				<div>
					<button type="submit" class="btn btn-lg btn-primary btn-block">
						<?php echo __( 'Log in', 'kanban' ); ?>
					</button>
					<input type="hidden" name="redirect" value="<?php echo isset($_GET['redirect']) ? urldecode($_GET['redirect']) : '' ?>">
					<?php wp_nonce_field( 'login', Kanban_Utils::get_nonce() ); ?>
				</div>
<?php else : // is_user_logged_in ?>
				<p>
					<?php echo __( 'Whoops, looks like you haven\'t been granted access yet. Click below to request access.', 'kanban' ); ?>
				</p>
				<p class="text-center">
					<button type="submit" class="btn btn-primary btn-lg">
						<?php echo __( 'Request access', 'kanban' ); ?>
					</button>
					<?php wp_nonce_field( 'request_access', Kanban_Utils::get_nonce() ); ?>
				</p>
<?php endif // is_user_logged_in ?>
			</div><!-- panel-body -->
<!--		</div>--><!-- panel -->
	</form>



</div><!-- row -->


</div><!--container-->

</body>
</html>

